/*
 * XXXX 
 *
 * Fecha 08/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;



/**
 *  Esta clase representa un modelo abstracto que sirve como gua de
 *  implementacin para los servlets de manejo de las pantallas de
 *  de la aplicacin.
 *  Incluye una serie de mtodos comunes a todos los servlets de manejo 
 *  de pantallas.
 */
public abstract class P06BServletGenerico extends P06BServlet {

    /**
     *  Representa la operacin de peticin HTTP get
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException
     *  @throws IOException
     */
    public void doGet (HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        doPost (request, response);
    }

    /**
     *  Representa la operacin de peticin HTTP post
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException 
     *  @throws IOException
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        if (verificarSesion(request, response)) {
            manejarErrorSesion(request, response);
        } else  {            
            manejarPeticion (request, response);
        }
    }

    /**
     *  Ejecuta la operacin requerida por el usuario desde una pantalla.
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException 
     *  @throws IOException
     */
    public void manejarPeticion (HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
    	try 
    	{
    	    ejecutar (request, response);
    	}

    	catch (Exception e) 
    	{
            e.printStackTrace();
    		manejarErrores (request, response, e);
    	}
    }

    /**
     *  Operacion abstracta que gestionar las diferentes operaciones que 
     *  se manejarn desde una pantalla.
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     */
    public abstract void ejecutar (HttpServletRequest request, HttpServletResponse response);

}